/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.BeneficioRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import ec.gob.sri.dimm.ats.ui.ConstantesUI;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoFideicomiso;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoInfoBeneficiario;
import ec.gob.sri.dimm.ats.ui.dialogos.filtros.IdentificacionFideicomisosFilter;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaFideicomisos
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private DataBindingContext m_bindingContext;
    private Fideicomiso fideicomisoSeleccionado;
    private BeneficioRetencion beneficiarioSeleccionado;
    private Iva modeloDatos;
    private Table tblFideicomisos;
    private Table tblBeneficiarios;
    private Text txtIdentificacion;
    private Button btnBuscar;
    private ToolItem tltmNuevoFideicomiso;
    private TableViewer tvFideicomisos;
    private ToolItem tltmEliminarFideicomiso;
    private ToolItem tltmEditarFideicomiso;
    private ToolItem tltmNuevoBeneficiario;
    private TableViewer tvBeneficiarios;
    private ToolItem tltmEliminarBeneficiario;
    private ToolItem tltmEditarBeneficiario;
    private IdentificacionFideicomisosFilter filtroFideicomisos;
    private Label lblRegistros;

    public PaginaFideicomisos(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnRecaps = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnRecaps);
        sctnRecaps.setText("Fondos y Fideicomisos");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnRecaps, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnRecaps.setClient((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        ExpandableComposite xcRecaps = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xcRecaps = new FormData();
        fd_xcRecaps.bottom = new FormAttachment(0, 250);
        fd_xcRecaps.top = new FormAttachment(0, 3);
        fd_xcRecaps.left = new FormAttachment(0, 3);
        xcRecaps.setLayoutData((Object)fd_xcRecaps);
        managedForm.getToolkit().paintBordersFor((Composite)xcRecaps);
        xcRecaps.setText("Informaci\u00f3n Fondos y Fideicomisos");
        Composite cRecap = new Composite((Composite)xcRecaps, 0);
        xcRecaps.setClient((Control)cRecap);
        managedForm.getToolkit().adapt(cRecap);
        managedForm.getToolkit().paintBordersFor(cRecap);
        cRecap.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabecera = new Composite(cRecap, 0);
        cCabecera.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(cCabecera);
        managedForm.getToolkit().paintBordersFor(cCabecera);
        GridLayout gl_cCabecera = new GridLayout(19, false);
        gl_cCabecera.marginWidth = 0;
        cCabecera.setLayout((Layout)gl_cCabecera);
        ToolBar toolBar = new ToolBar(cCabecera, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 16, 1);
        gd_toolBar.widthHint = 330;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevoFideicomiso = new ToolItem(toolBar, 0);
        this.tltmNuevoFideicomiso.setText("Nuevo");
        this.tltmEditarFideicomiso = new ToolItem(toolBar, 0);
        this.tltmEditarFideicomiso.setText("Editar");
        this.tltmEliminarFideicomiso = new ToolItem(toolBar, 0);
        this.tltmEliminarFideicomiso.setText("Eliminar");
        Label lblNIdentificacin = new Label(cCabecera, 0);
        GridData gd_lblNIdentificacin = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNIdentificacin.widthHint = 100;
        lblNIdentificacin.setLayoutData((Object)gd_lblNIdentificacin);
        managedForm.getToolkit().adapt((Control)lblNIdentificacin, true, true);
        lblNIdentificacin.setText("N\u00b0 Identificaci\u00f3n");
        this.txtIdentificacion = new Text(cCabecera, 2048);
        this.txtIdentificacion.setTextLimit(13);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdentificacion.widthHint = 120;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        managedForm.getToolkit().adapt((Control)this.txtIdentificacion, true, true);
        this.btnBuscar = new Button(cCabecera, 0);
        this.btnBuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBuscar, true, true);
        this.tvFideicomisos = new TableViewer(cRecap, 67584);
        this.filtroFideicomisos = new IdentificacionFideicomisosFilter();
        this.filtroFideicomisos.setSearchText("");
        this.tvFideicomisos.addFilter((ViewerFilter)this.filtroFideicomisos);
        this.tvFideicomisos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaFideicomisos.this.fideicomisoSeleccionado = (Fideicomiso)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                PaginaFideicomisos.this.beneficiarioSeleccionado = null;
                AyudanteViewer.seleccionarElemento((Viewer)PaginaFideicomisos.this.tvBeneficiarios, null);
            }
        });
        this.tblFideicomisos = this.tvFideicomisos.getTable();
        this.tblFideicomisos.setLinesVisible(true);
        this.tblFideicomisos.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblFideicomisos);
        TableColumn tblclmnNIdFideicomiso = new TableColumn(this.tblFideicomisos, 0);
        tblclmnNIdFideicomiso.setWidth(180);
        tblclmnNIdFideicomiso.setText("N\u00b0 RUC Fideicomiso");
        TableColumn tblclmnTipoFideicomiso = new TableColumn(this.tblFideicomisos, 0);
        tblclmnTipoFideicomiso.setWidth(300);
        tblclmnTipoFideicomiso.setText("Tipo Fondo/Fideicomiso");
        TableColumn tblclmnTotalBeneficio = new TableColumn(this.tblFideicomisos, 0);
        tblclmnTotalBeneficio.setWidth(108);
        tblclmnTotalBeneficio.setText("Total Beneficio");
        Composite cRegistros = new Composite(cRecap, 0);
        cRegistros.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(cRegistros);
        managedForm.getToolkit().paintBordersFor(cRegistros);
        cRegistros.setLayout((Layout)new GridLayout(1, false));
        this.lblRegistros = new Label(cRegistros, 0);
        GridData gd_lblRegistros = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegistros.widthHint = 500;
        this.lblRegistros.setLayoutData((Object)gd_lblRegistros);
        managedForm.getToolkit().adapt((Control)this.lblRegistros, true, true);
        ExpandableComposite xcAir = managedForm.getToolkit().createExpandableComposite(composite, 512);
        FormData fd_xcAir = new FormData();
        fd_xcAir.top = new FormAttachment((Control)xcRecaps, 10);
        fd_xcAir.bottom = new FormAttachment(0, 400);
        fd_xcAir.left = new FormAttachment(0, 3);
        xcAir.setLayoutData((Object)fd_xcAir);
        managedForm.getToolkit().paintBordersFor((Composite)xcAir);
        xcAir.setText("Detalle de Beneficiarios");
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)xcAir, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        xcAir.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabeceraAir = managedForm.getToolkit().createComposite(composite_1, 0);
        cCabeceraAir.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(cCabeceraAir);
        ToolBar toolBar_1 = new ToolBar(cCabeceraAir, 0x820000);
        toolBar_1.setBounds(0, 0, 200, 23);
        managedForm.getToolkit().adapt((Composite)toolBar_1);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_1);
        this.tltmNuevoBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmNuevoBeneficiario.setText("Nuevo");
        this.tltmEditarBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmEditarBeneficiario.setText("Editar");
        this.tltmEliminarBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmEliminarBeneficiario.setText("Eliminar");
        this.tvBeneficiarios = new TableViewer(composite_1, 67584);
        this.tvBeneficiarios.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaFideicomisos.this.beneficiarioSeleccionado = (BeneficioRetencion)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.tblBeneficiarios = this.tvBeneficiarios.getTable();
        this.tblBeneficiarios.setLinesVisible(true);
        this.tblBeneficiarios.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblBeneficiarios);
        TableColumn tblclmnTipoIdBeneficiario = new TableColumn(this.tblBeneficiarios, 0);
        tblclmnTipoIdBeneficiario.setWidth(120);
        tblclmnTipoIdBeneficiario.setText("Tipo Id Beneficiario");
        TableColumn tblclmnIdBeneficiario = new TableColumn(this.tblBeneficiarios, 0);
        tblclmnIdBeneficiario.setWidth(150);
        tblclmnIdBeneficiario.setText("N\u00b0 Id Beneficiario");
        TableColumn tblclmnBeneficioIndividual = new TableColumn(this.tblBeneficiarios, 0);
        tblclmnBeneficioIndividual.setWidth(120);
        tblclmnBeneficioIndividual.setText("Beneficio Individual");
        TableColumn tblclmnRetencin = new TableColumn(this.tblBeneficiarios, 0);
        tblclmnRetencin.setWidth(100);
        tblclmnRetencin.setText("% Retenci\u00f3n");
        TableColumn tblclmnValorRetenido = new TableColumn(this.tblBeneficiarios, 0);
        tblclmnValorRetenido.setWidth(100);
        tblclmnValorRetenido.setText("Valor Retenido");
        this.initDataBindings();
        this.bntNuevoFideicomisoClicked();
        this.btnEditarFideicomisoClicked();
        this.btnEliminarFideicomisoClicked();
        this.btnNuevoBeneficiarioClicked();
        this.btnEditarBeneficiarioClicked();
        this.btnEliminarBeneficiarioClicked();
        this.btnBuscarClicked();
    }

    private void generarAlertaFiltro(String textoFiltro) {
        if (StringUtil.isNullOrEmpty((String)textoFiltro)) {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FOREGROUND);
            this.lblRegistros.setText(String.format("Total Registros: %d %s", this.modeloDatos.getFideicomisos().size(), "Fideicomiso(s)"));
        } else {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FILTRO);
            this.lblRegistros.setText(String.format("N\u00famero de registros filtrados: %d, de un total de %d %s", this.tvFideicomisos.getTable().getItemCount(), this.modeloDatos.getFideicomisos().size(), "Fideicomiso(s)"));
        }
    }

    private void btnBuscarClicked() {
        this.btnBuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaFideicomisos.this.filtroFideicomisos.setSearchText(PaginaFideicomisos.this.txtIdentificacion.getText());
                PaginaFideicomisos.this.tvFideicomisos.refresh();
                PaginaFideicomisos.this.generarAlertaFiltro(PaginaFideicomisos.this.txtIdentificacion.getText());
            }
        });
    }

    private void bntNuevoFideicomisoClicked() {
        this.tltmNuevoFideicomiso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Fideicomiso fideicomiso = new Fideicomiso();
                fideicomiso.setPropietario((ObjetoModelo)PaginaFideicomisos.this.modeloDatos);
                if (PaginaFideicomisos.this.abrirDialogoFideicomiso(fideicomiso, false)) {
                    PaginaFideicomisos.this.modeloDatos.agregarAdministradorFondos(fideicomiso);
                    ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                    PaginaFideicomisos.this.generarAlertaFiltro(PaginaFideicomisos.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void btnEditarFideicomisoClicked() {
        this.tltmEditarFideicomiso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFideicomisos.this.fideicomisoSeleccionado != null) {
                    Fideicomiso copiaEdicion = PaginaFideicomisos.this.fideicomisoSeleccionado.crearCopiaEdicion();
                    if (PaginaFideicomisos.this.abrirDialogoFideicomiso(copiaEdicion, true)) {
                        PaginaFideicomisos.this.fideicomisoSeleccionado.actualizarInformacion(copiaEdicion);
                        PaginaFideicomisos.this.tvFideicomisos.refresh();
                        ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                    }
                } else {
                    PaginaFideicomisos.this.mostrarAdvertencia("No ha seleccionado un fondo o fideicomiso");
                }
            }
        });
    }

    private void btnEliminarFideicomisoClicked() {
        this.tltmEliminarFideicomiso.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFideicomisos.this.fideicomisoSeleccionado != null && PaginaFideicomisos.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaFideicomisos.this.modeloDatos.eliminarFdeicomiso(PaginaFideicomisos.this.fideicomisoSeleccionado)) {
                    PaginaFideicomisos.this.fideicomisoSeleccionado = null;
                    ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                    PaginaFideicomisos.this.generarAlertaFiltro(PaginaFideicomisos.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void btnNuevoBeneficiarioClicked() {
        this.tltmNuevoBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFideicomisos.this.fideicomisoSeleccionado != null) {
                    BeneficioRetencion beneficiario = new BeneficioRetencion();
                    beneficiario.setPropietario((ObjetoModelo)PaginaFideicomisos.this.fideicomisoSeleccionado);
                    if (PaginaFideicomisos.this.abrirDialogoBeneficiario(beneficiario, false)) {
                        PaginaFideicomisos.this.fideicomisoSeleccionado.agregarBeneficioRetencion(beneficiario);
                        PaginaFideicomisos.this.tvBeneficiarios.refresh();
                        ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                    }
                } else {
                    PaginaFideicomisos.this.mostrarAdvertencia("No ha seleccionado un fondo o fideicomiso");
                }
            }
        });
    }

    private boolean abrirDialogoBeneficiario(BeneficioRetencion modeloDatos, boolean editando) {
        ArrayList<Sujeto> beneficiariosExistentes = new ArrayList<Sujeto>();
        for (BeneficioRetencion beneficio : ((Fideicomiso)modeloDatos.getPropietario()).getBeneficiosRetencion()) {
            beneficiariosExistentes.add((Sujeto)beneficio.getBeneficiario());
        }
        DialogoInfoBeneficiario dialogo = new DialogoInfoBeneficiario(this.getSite(), beneficiariosExistentes, editando, this.modeloDatos.periodo);
        dialogo.setModeloDatos(modeloDatos);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void btnEditarBeneficiarioClicked() {
        this.tltmEditarBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFideicomisos.this.beneficiarioSeleccionado != null) {
                    BeneficioRetencion copiaEdicion = PaginaFideicomisos.this.beneficiarioSeleccionado.crearCopiaEdicion();
                    PaginaFideicomisos.this.fideicomisoSeleccionado.restarBeneficioIndividualEdicion(PaginaFideicomisos.this.beneficiarioSeleccionado);
                    if (PaginaFideicomisos.this.abrirDialogoBeneficiario(copiaEdicion, true)) {
                        PaginaFideicomisos.this.beneficiarioSeleccionado.actualizarInformacion(copiaEdicion);
                        PaginaFideicomisos.this.tvBeneficiarios.refresh();
                        ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                    }
                    PaginaFideicomisos.this.fideicomisoSeleccionado.sumarBeneficioIndividualEdicion(PaginaFideicomisos.this.beneficiarioSeleccionado);
                } else {
                    PaginaFideicomisos.this.mostrarAdvertencia("No ha seleccionado un fondo o fideicomiso");
                }
            }
        });
    }

    private void btnEliminarBeneficiarioClicked() {
        this.tltmEliminarBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaFideicomisos.this.beneficiarioSeleccionado != null && PaginaFideicomisos.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaFideicomisos.this.fideicomisoSeleccionado.eliminarBeneficioRetencion(PaginaFideicomisos.this.beneficiarioSeleccionado)) {
                    PaginaFideicomisos.this.beneficiarioSeleccionado = null;
                    ((EditorATS)PaginaFideicomisos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaFideicomisos.this.modeloDatos);
                }
            }
        });
    }

    private boolean abrirDialogoFideicomiso(Fideicomiso modeloDatos, boolean editando) {
        DialogoFideicomiso dialogo = new DialogoFideicomiso(this.getSite(), this.modeloDatos.getFideicomisos(), editando);
        dialogo.setModeloDatos(modeloDatos);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Fideicomiso.class, (String[])new String[]{"rucFideicomiso", "descripcionTipoFideicomiso", "montoBeneficioTotal"});
        this.tvFideicomisos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvFideicomisos.setContentProvider((IContentProvider)listContentProvider);
        IObservableList fideicomisosModeloDatosObserveList = BeanProperties.list((String)"fideicomisos").observe((Object)this.modeloDatos);
        this.tvFideicomisos.setInput((Object)fideicomisosModeloDatosObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), BeneficioRetencion.class, (String[])new String[]{"beneficiario.descripcionTipoIdentificacion", "beneficiario.identificacion", "montoBeneficioIndividual", "porcentajeRetencion", "montoRentencionRenta"});
        this.tvBeneficiarios.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_1));
        this.tvBeneficiarios.setContentProvider((IContentProvider)listContentProvider_1);
        IViewerObservableValue tvFideicomisosObserveSingleSelection = ViewersObservables.observeSingleSelection((Viewer)this.tvFideicomisos);
        IObservableList tvFideicomisosBeneficiosRetencionObserveDetailList = BeansObservables.observeDetailList((IObservableValue)tvFideicomisosObserveSingleSelection, (String)"beneficiosRetencion", BeneficioRetencion.class);
        this.tvBeneficiarios.setInput((Object)tvFideicomisosBeneficiosRetencionObserveDetailList);
        this.generarAlertaFiltro(this.txtIdentificacion.getText());
        return bindingContext;
    }
}

